class goWarShell2 extends Projectile;

#exec TEXTURE IMPORT NAME=Trollface FILE=TEXTURES\Trollface.bmp LODSET=2

#exec MESH IMPORT MESH=portal ANIVFILE=MODELS\portal_a.3d DATAFILE=MODELS\portal_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=portal X=-30 Y=0 Z=0
#exec MESH SEQUENCE MESH=portal SEQ=All    STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=portal SEQ=portal STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW   MESHMAP=portal MESH=portal
#exec MESHMAP SCALE MESHMAP=portal X=0.1 Y=0.1 Z=0.2

#exec AUDIO IMPORT FILE="Sounds\trollfacesound.wav" NAME="trollfacesound" GROUP=Redeemer

var float CannonTimer, SmokeRate;
var redeemertrail trail;

simulated function Timer()
{
    local goUT_SpriteSmokePuff b;

    CannonTimer += SmokeRate;
    if ( CannonTimer > 0.6 )
    {
        WarnCannons();
        CannonTimer -= 0.6;
    }

    if ( Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer) )
    {
        SetTimer(SmokeRate, false);
        Return;
    }

    if ( Level.bHighDetailMode )
    {
        if ( Level.bDropDetail )
            Spawn(class'LightSmokeTrail');
        else
            Spawn(class'goUTSmokeTrail');
        SmokeRate = 152/Speed; 
    }
    else 
    {
        SmokeRate = 0.15;
        b = Spawn(class'goUT_SpriteSmokePuff');
        b.RemoteRole = ROLE_None;
    }
    SetTimer(SmokeRate, false);
}

simulated function Destroyed()
{
    if ( Trail != None )
        Trail.Destroy();
    Super.Destroyed();
}

simulated function PostBeginPlay()
{
    SmokeRate = 0.3;
    SetTimer(0.3,false); 
}

function WarnCannons()
{
    local Pawn P;

    for ( P=Level.Pawnlist; P!=None; P=P.NextPawn )
        if ( P.IsA('TeamCannon') && !P.IsInState('TrackWarhead') && P.LineOfSightTo(self) )
        {
            P.target = self;
            P.GotoState('TrackWarhead');
        }
}

singular function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, vector momentum, name damageType )
{
    if ( NDamage > 5 )
    {
        PlaySound(Sound'goblast',,6.0);
        spawn(class'goWarExplosion',,,Location);
        HurtRadius(Damage,350.0, MyDamageType, MomentumTransfer, HitLocation );
        RemoteRole = ROLE_SimulatedProxy;                   
        Destroy();
    }
}

auto state Flying
{
    simulated function ZoneChange( Zoneinfo NewZone )
    {
        local waterring w;
        
        if ( NewZone.bWaterZone != Region.Zone.bWaterZone )
        {
            w = Spawn(class'WaterRing',,,,rot(16384,0,0));
            w.DrawScale = 0.2;
            w.RemoteRole = ROLE_None; 
        }   
    }

    function ProcessTouch (Actor Other, Vector HitLocation)
    {
        if ( Other != instigator ) 
            Explode(HitLocation,Normal(HitLocation-Other.Location));
    }

    function Explode(vector HitLocation, vector HitNormal)
    {
        if ( Role < ROLE_Authority )
            return;

        HurtRadius(Damage,300.0, MyDamageType, MomentumTransfer, HitLocation );                 
        spawn(class'TOMShockWave',,,HitLocation+ HitNormal*16);
        RemoteRole = ROLE_SimulatedProxy;                   
        Destroy();
    }

    function BeginState()
    {
        local vector InitialDir;

        initialDir = vector(Rotation);
        if ( Role == ROLE_Authority )   
            Velocity = speed*initialDir;
        Acceleration = initialDir*50;
    }
}

simulated function HitWall (vector HitNormal, actor Wall)
{
    if ( Role == ROLE_Authority )
    {
        if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
            Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), '');

        MakeNoise(1.0);
    }
    Explode(Location + ExploWallOut * HitNormal, HitNormal);
    if ( (ExplosionDecal != None) && (Level.NetMode != NM_DedicatedServer) )
       Spawn(ExplosionDecal,self,,Location, rotator(HitNormal));
       ExplosionDecal = None;
}

defaultproperties
{
    ExplosionDecal=class'RidiculousDeemer.goNuclearMarktroll'
    DrawScale=0.800000
    speed=800.000000
    Damage=200.000000
    MomentumTransfer=10000
    MyDamageType=RedeemerDeath
    bNetTemporary=False
    RemoteRole=ROLE_SimulatedProxy
    Mesh=LodMesh'Portal'
    AmbientGlow=78
    bUnlit=True
    SoundRadius=100
    SoundVolume=255
    AmbientSound=Sound'trollfacesound'
    CollisionRadius=15.000000
    CollisionHeight=8.000000
    bProjTarget=True
    Texture=Texture'Trollface'
    bFixedRotationDir=True
    LightType=LT_Steady
    LightEffect=10
    LightBrightness=255
    LightHue=153
    LightRadius=30
    AmbientGlow=187
    DrawType=DT_Sprite
    SoundRadius=60
    SoundVolume=255
    Style=STY_Modulated
}